#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using RPC = gov.va.med.vbecs.DAL.VAL.RPC;

#endregion
namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_Workload : BaseTest 
	{
		private RPC.Workload _tstWL;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			this._tstWL = new RPC.Workload();
		}

		[Test]
		public void GetPendingWorkloadData_Pass()
		{
			string tstValue = this._tstWL.GetPendingWorkloadData( "P" );
			
			Assert.IsTrue(tstValue != string.Empty );
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetPendingWorkloadData_Fail()
		{
			this._tstWL.GetPendingWorkloadData(string.Empty);
		}


		[Test]
		public void UpdateWorkloadEvent_Pass()
		{
			string tstValue = this._tstWL.UpdateWorkloadEvent( "43D25CBF-7DE0-4FB2-9D42-02D12384D3A5","S", "3040728.23183", "", "" );
			
			Assert.IsTrue(tstValue != string.Empty);
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void UpdateWorkloadEvent_Fail()
		{
			string tstValue = this._tstWL.UpdateWorkloadEvent( "","","","","");
		}
	}
}
#endif
